(function(){
  window.__recaptchaId = null;
  // Speed-up on iOS Safari: preconnect/dns-prefetch to reCAPTCHA origins (no UI changes)
  try{
    var origins = ['https://www.google.com','https://www.gstatic.com','https://www.recaptcha.net'];
    origins.forEach(function(o){
      var l1 = document.createElement('link'); l1.rel = 'preconnect'; l1.href = o; l1.crossOrigin = 'anonymous'; document.head.appendChild(l1);
      var l2 = document.createElement('link'); l2.rel = 'dns-prefetch'; l2.href = o; document.head.appendChild(l2);
    });
  }catch(_e){}

  function readSiteKey(){
    try{
      var m = document.querySelector('meta[name="recaptcha-site-key"]');
      if (m && m.content) return m.content.trim();
      if (typeof window.RECAPTCHA_SITE_KEY === 'string' && window.RECAPTCHA_SITE_KEY) return window.RECAPTCHA_SITE_KEY;
    }catch(e){}
    try{ console.warn('reCAPTCHA: site key not set. Add <meta name="recaptcha-site-key" content="...">'); }catch(_e){}
    return '';
  }

  window.initRecaptcha = function(){
    try{
      if (typeof grecaptcha === 'undefined') return;
      var el = document.getElementById('recaptchaWidget');
if (window.__recaptchaId !== null) return;
if (!el){
  // iOS/slow devices race fix: wait until the widget element exists, then render
  try{
    if (document.readyState === 'loading'){
      document.addEventListener('DOMContentLoaded', function once(){ try{ document.removeEventListener('DOMContentLoaded', once); window.initRecaptcha(); }catch(e){} }, { once:true });
    }
  }catch(_e){}
  (function poll(){ 
    var el2 = document.getElementById('recaptchaWidget');
    if (el2){ try{ window.initRecaptcha(); }catch(e){} return; }
    setTimeout(poll, 100);
  })();
  return;
}


      var SITE_KEY = readSiteKey();
      window.__recaptchaId = grecaptcha.render(el, {
        sitekey: SITE_KEY || 'PLEASE_SET_SITE_KEY',
        theme: 'light',
        callback: function(token){
          try{
            var t = document.getElementById('gRecaptchaToken');
            if (t) t.value = token || (grecaptcha.getResponse(window.__recaptchaId) || '');
            if (window.onRecaptchaOK) window.onRecaptchaOK(token);
          }catch(e){}
        },
        'expired-callback': function(){
          try{
            var t = document.getElementById('gRecaptchaToken');
            if (t) t.value = '';
            if (window.onRecaptchaExpired) window.onRecaptchaExpired();
          }catch(e){}
        }
      });
    }catch(e){}
  };

  (function attach(src){
  if (window.__recaptchaScriptLoading) return;
  window.__recaptchaScriptLoading = true;
  var loaded = false, alternateLoaded = false;
  var s = document.createElement('script');
  s.src = src + (src.indexOf('?')>-1?'&':'?') + 'hl=ar&onload=initRecaptcha&render=explicit';
  s.async = true; s.defer = true;
  s.onload = function(){ loaded = true; };
  s.onerror = function(){ 
    if (!alternateLoaded){
      alternateLoaded = true;
      attach('https://www.recaptcha.net/recaptcha/api.js');
    }
  };
  document.head.appendChild(s);
  // If primary domain is slow/blocked, try alternate after 3 seconds (no UI changes)
  setTimeout(function(){
    if (!loaded && !alternateLoaded){
      alternateLoaded = true;
      attach('https://www.recaptcha.net/recaptcha/api.js');
    }
  }, 3000);
})('https://www.google.com/recaptcha/api.js');

})();