<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('X-Content-Type-Options: nosniff');

function out($arr){ echo json_encode($arr, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

$config = require __DIR__ . '/../config.php';
$secret = $config['recaptcha_secret'] ?? '';
if (!$secret) out(['ok'=>false,'where'=>'config','msg'=>'recaptcha_secret مفقود في config.php']);

$ch = curl_init('https://www.google.com/recaptcha/api/siteverify');
curl_setopt_array($ch,[
  CURLOPT_RETURNTRANSFER=>true,
  CURLOPT_POST=>true,
  CURLOPT_POSTFIELDS=>http_build_query(['secret'=>$secret,'response'=>'dummy-invalid-token']),
  CURLOPT_TIMEOUT=>10,
]);
$resp = curl_exec($ch);
$err  = curl_error($ch);
$info = curl_getinfo($ch);
curl_close($ch);

if ($resp === false) {
  out(['ok'=>false,'where'=>'curl','msg'=>'فشل الاتصال بخدمة reCAPTCHA','error'=>$err,'info'=>$info]);
}
$out = json_decode($resp, true);
out(['ok'=>true,'reachable'=>true,'http_code'=>$info['http_code'] ?? null,'recaptcha_success'=>($out['success'] ?? false), 'raw'=>$out]);
